<!-- simonchanged -->

<?php $__env->startSection('title', __( 'Payment Gateway Settings' )); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo app('translator')->get( 'Payment Gateway Settings' ); ?>
        <small><?php echo app('translator')->get( 'Manage your payment gateway settings' ); ?></small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __( 'Payment Gateways' )]); ?>

    <?php $__env->slot('tool'); ?>
    <div class="box-tools">
        <button type="button" class="btn btn-block btn-primary btn-modal" id="mpesa_trigger_btn">
            <i class="fa fa-plus"></i> <?php echo app('translator')->get( 'messages.add' ); ?></button>
    </div>
    <?php $__env->endSlot(); ?>

    <div class="table-responsive">
        <table class="table table-bordered table-striped" id="payment_gateways_table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get( 'Provider' ); ?></th>
                    <th><?php echo app('translator')->get( 'Shortcode' ); ?></th>
                    <th><?php echo app('translator')->get( 'Shortcode Type' ); ?></th>
                    <th><?php echo app('translator')->get( 'Action' ); ?></th>
                </tr>
            </thead>
            <tbody id="table_content">

            </tbody>
        </table>
    </div>

    <?php echo $__env->renderComponent(); ?>



    <div class="modal fade payment_gateways_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

                <?php echo Form::open(['method' => 'post', 'id' => 'save_gateway' ]); ?>


                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php echo app('translator')->get( 'Add Payment Gateway Settings' ); ?></h4>
                </div>

                <div class="modal-body">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-4 col-xs-12">
                                <input name="location_id" type="hidden" value="405">
                            </div>
                            <div class="clearfix"></div>


                            <div class="col-md-4 col-xs-12">
                                <div class="form-group">
                                    <label for="payment gateway type">Payment gateway type:*</label>
                                    <select class="form-control select2 valid" required="" autofocus="" id="provider" name="provider" aria-required="true" aria-invalid="false">
                                        <option selected="selected" value="">Select payment gateway type</option>
                                        <option value="mpesa">MPESA</option>
                                        <!-- <option value="kopokopo">KOPOKOPO</option>
                                        <option value="equity">EQUITY</option> -->
                                    </select>
                                </div>
                            </div>
                            <div class="clearfix"></div>




                            <div class="payment_gateway_settings" data-service="mpesa">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="shortcode">Shortcode:*</label>
                                        <input class="form-control" required="" placeholder="Shortcode" id="mpesa_shortcode" name="mpesa_shortcode" type="text" aria-required="true">
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="consumer_key">Consumer Key:</label>
                                        <input class="form-control" placeholder="Consumer Key" id="mpesa_consumerkey" name="mpesa_consumerkey" type="text">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="consumer_secret">Consumer Secret:</label>
                                        <input class="form-control" placeholder="Consumer Secret" id="mpesa_consumersecret" name="mpesa_consumersecret" type="text">
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="passkey">Passkey:*</label>
                                        <input class="form-control" placeholder="Passkey" required="" id="mpesa_passkey" name="mpesa_passkey" type="text" aria-required="true">
                                    </div>
                                </div>


                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="paybill/till">Paybill or Till:*</label> <i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" data-container="body" data-toggle="popover" data-placement="auto bottom" data-content="Pick the shortcode type you are using in your organization" data-html="true" data-trigger="hover"></i> 
                                        <select class="form-control" required="" id="mpesa_shortcode_type" name="mpesa_shortcode_type" aria-required="true">
                                            <option selected="selected" value="">Please Select</option>
                                            <option value="paybill">MPESA PAYBILL</option>
                                            <option value="till">MPESA TILL</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6" id="till_number">
                                    <label for="passkey">Till Number:*</label>
                                    <input type="text" id="till"  name="till_number" class="form-control">
                                </div> 
                                <div class="col-sm-6">
                                    <input type="submit" id="saveButton" class="btn btn-primary" value="Save">
                                </div>
                            </div>



                        </div>
                    </div>

                    <?php echo Form::close(); ?>


                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>


</section>


<!-- /.content -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>
<script>
    $(document).ready(function() {
        //hide till_number
        $('#till_number').hide();

        //show till_number if mpesa_shortcode_type is till

        $('#mpesa_shortcode_type').change(function() {
            if ($(this).val() == 'till') {
                $('#till_number').show();
            } else {
                $('#till_number').hide();
            }
        });



        getGatewaysData();
        let mpesa_btn = $('#mpesa_trigger_btn');
        mpesa_btn.click(function(e) {
            $('.payment_gateways_modal').modal('show');
        })
        $('#save_gateway').submit(function(e) {
            e.preventDefault();
            let provider = $('#provider').val();
            let mpesa_shortcode = $('#mpesa_shortcode').val();
            let mpesa_passkey = $('#mpesa_passkey').val();
            let mpesa_consumerkey = $('#mpesa_consumerkey').val();
            let mpesa_consumersecret = $('#mpesa_consumersecret').val();
            let mpesa_shortcode_type = $('#mpesa_shortcode_type').val();
            let till_number = $('#till').val();
            let _token = $('meta[name="csrf-token"]').attr('content');

            let data = {
                provider,
                mpesa_passkey,
                mpesa_consumerkey,
                mpesa_consumersecret,
                mpesa_shortcode,
                mpesa_shortcode_type,
                till_number,
                _token

            }
            $.ajax({
                url: '/payment-gateways/store',
                type: 'POST',
                data: data,
                success: function(data) {
                    if (data.status == 'success') {
                        let contentDiv = $('#table_content');
                        getGatewaysData();
                        toastr.success(data.message);

                        $('.payment_gateways_modal').modal('hide');
                    } else {
                        toastr.error(data.message);
                        console.log('error-data:', data)
                    }
                },

                error: function(data) {
                    toastr.error(data.message);
                    console.log('error-data:', data)
                }
            });

        })




    })

    function getGatewaysData() {
        $.ajax({
            url: '/gateway-data',
            type: 'GET',
            success: function(data) {
                console.log(data);
                if (data.status == 'success') {
                    console.log('data:', data)
                    let contentDiv = $('#table_content');
                    let tr = `<tr>
                                    <td>${data.data.provider}</td>
                                    <td>${data.data.mpesa_shortcode}</td>
                                    <td>${data.data.mpesa_shortcode_type}</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary edit-gateway" data-id="${data.data.id}" data-provider="${data.data.provider}" data-shortcode="${data.data.mpesa_shortcode}" data-type="${data.data.mpesa_shortcode_type}">Edit</button>
                                        <button class="btn btn-sm btn-danger delete-gateway" data-id="${data.data.id}">Delete</button>
                                    </td>
                                </tr>`;
                    contentDiv.append(tr);
                    $('#payment_gateways_table').DataTable();
                    $('.payment_gateways_modal').modal('hide');
                } else {
                    toastr.error(data.message);
                    console.log('error-data:', data)
                }
            },

            error: function(data) {
                toastr.error(data.message);
                console.log('error-data:', data)
            }
        });
    }
    
    // Handle Edit Button Click
    $(document).on('click', '.edit-gateway', function() {
        let id = $(this).data('id');
        let provider = $(this).data('provider');
        let shortcode = $(this).data('shortcode');
        let type = $(this).data('type');
        let consumerkey = $(this).data('consumerkey');
        let consumersecret = $(this).data('consumersecret');
        let passkey = $(this).data('passkey');
        let till = $(this).data('till');
        
        $('#save_gateway #gateway_id').val(id);
        $('#save_gateway #provider').val(provider);
        $('#save_gateway #mpesa_shortcode').val(shortcode);
        $('#save_gateway #mpesa_shortcode_type').val(type);
        $('#save_gateway #mpesa_consumerkey').val(consumerkey);
        $('#save_gateway #mpesa_consumersecret').val(consumersecret);
        $('#save_gateway #mpesa_passkey').val(passkey);
        $('#save_gateway #till').val(till);
        
        $('.payment_gateways_modal').modal('show');
    });
    // Handle Update AJAX
    $('#save_gateway').submit(function(e) {
        e.preventDefault();
        let id = $('#gateway_id').val();
        let formData = $(this).serialize();
        
        $.ajax({
            url: '/gateway/update/' + id,
            type: 'POST',
            data: formData,
            success: function(response) {
                if (response.status == 'success') {
                    toastr.success("Gateway updated successfully");
                    $('.payment_gateways_modal').modal('hide');
                    getGatewaysData();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function() {
                toastr.error("Error updating gateway");
            }
        });
    });
    
    // Handle Delete Button Click
    $(document).on('click', '.delete-gateway', function() {
        let id = $(this).data('id');
        if (confirm("Are you sure you want to delete this gateway?")) {
            $.ajax({
                url: '/gateway/delete/' + id,
                type: 'DELETE',
                success: function(response) {
                    if (response.status == 'success') {
                        toastr.success("Gateway deleted successfully");
                        $('#row_' + id).remove();
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function() {
                    toastr.error("Error deleting gateway");
                }
            });
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/palmsyst/kalulupharmacy.palmsystems.co.ke/resources/views/payment_gateways/create.blade.php ENDPATH**/ ?>